/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import CH.ifa.draw.util.Storable;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareChangedEvent;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Language;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Measurement
implements Serializable,
Storable,
Cloneable {
    private List fAvailableSensors;
    static final long serialVersionUID = 1L;
    private int serializedDataVersion = 3;
    private int fGain = 100;
    private Sensor fSensor;
    private int fOffset = 0;
    private AnalogCalculationMethod fAnalogCalculationMethod;
    private int fSensorIndex = 0;
    private boolean fPT100HighResolution = true;
    private char fPT100Unit = (char)67;
    private Hardware fHardware;

    public Measurement() {
        this.fAnalogCalculationMethod = new AnalogCalculation0BA3();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public int getGain() {
        return this.getSensor().getGain();
    }

    public IntValueProperties getGainProperties() {
        return this.getSensor().getGainProperties();
    }

    public double getMaxMeasuredValue() {
        return this.getSensor().getMaxAmplifiedValue();
    }

    public double getMinMeasuredValue() {
        return this.getSensor().getMinAmplifiedValue();
    }

    public int getOffset() {
        return this.getSensor().getOffset();
    }

    public IntValueProperties getOffsetProperties() {
        return this.getSensor().getOffsetProperties();
    }

    public List getAvailableSensors() {
        AnalogCalculationMethod analogCalculationMethod = this.getAnalogCalculationMethod();
        if (this.fAvailableSensors == null) {
            if (Language.getString("pt100", "true").equals("true")) {
                this.fAvailableSensors = new ArrayList(6);
                this.fAvailableSensors.add(new Sensor0to10V(analogCalculationMethod));
                this.fAvailableSensors.add(new Sensor0to20mA(analogCalculationMethod));
                this.fAvailableSensors.add(new Sensor4to20mA(analogCalculationMethod));
                this.fAvailableSensors.add(new SensorPT100(analogCalculationMethod));
                this.fAvailableSensors.add(new SensorNoSensor(analogCalculationMethod));
            } else {
                this.fAvailableSensors = new ArrayList(3);
                this.fAvailableSensors.add(new Sensor0to10V(analogCalculationMethod));
                this.fAvailableSensors.add(new Sensor0to20mA(analogCalculationMethod));
                this.fAvailableSensors.add(new Sensor4to20mA(analogCalculationMethod));
                this.fAvailableSensors.add(new SensorNoSensor(analogCalculationMethod));
            }
        }
        return this.fAvailableSensors;
    }

    public void read(StorableInput dr) throws IOException {
        this.fSensor = (Sensor)dr.readStorable();
        this.fAnalogCalculationMethod = (AnalogCalculationMethod)dr.readStorable();
        this.fGain = dr.readInt();
        this.fOffset = dr.readInt();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (this.serializedDataVersion < 3) {
            this.serializedDataVersion = 3;
            this.fSensor = (Sensor)this.getAvailableSensors().get(this.fSensorIndex);
            if (this.fSensor instanceof SensorPT100) {
                SensorPT100 sensorPT100 = (SensorPT100)this.fSensor;
                sensorPT100.setHighResolution(this.fPT100HighResolution);
                sensorPT100.setUnit(this.fPT100Unit);
            } else {
                this.fSensor.setGainOffset(this.fGain, this.fOffset);
            }
        }
    }

    public void setGain(int newGain) {
        this.getSensor().setGainOffset(newGain, this.getOffset());
    }

    public void setOffset(int newOffset) {
        this.getSensor().setGainOffset(this.getGain(), newOffset);
    }

    public void setValues(Measurement newValues) {
        this.fGain = newValues.getGain();
        this.fOffset = newValues.getOffset();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("gain:\t").append(this.getGain()).append("\noffset:\t").append(this.getOffset()).append("\nminValue:\t").append(this.getMinMeasuredValue()).append("\nmaxValue:\t").append(this.getMaxMeasuredValue());
        return result.toString();
    }

    public void write(StorableOutput dw) {
        dw.writeStorable(this.fSensor);
        dw.writeStorable(this.fAnalogCalculationMethod);
        dw.writeInt(this.fGain);
        dw.writeInt(this.fOffset);
    }

    public int getAmplifiedValue(int source) {
        return this.fAnalogCalculationMethod.calculateAmplifiedValue(source, this.getGain(), this.getOffset());
    }

    public Sensor getSensor() {
        if (this.fSensor == null) {
            this.fSensor = new Sensor0to10V(this.fAnalogCalculationMethod);
        }
        if (this.fSensor instanceof SensorPT100Invers) {
            int gain = this.fSensor.getGain();
            int offset = this.fSensor.getOffset();
            this.fSensor = new SensorNoSensor(this.fAnalogCalculationMethod);
            this.fSensor.setGainOffset(gain, offset);
            System.out.println("Replace SensorPT100Invers with SensorNoSensor.");
        }
        return this.fSensor;
    }

    public void setSensor(Sensor sensor) {
        this.fSensor = sensor;
        this.fSensor.setAnalogCalculationMethod(this.fAnalogCalculationMethod);
    }

    public void setSensor(int sensorTypeID, Hardware hardware) {
        this.fHardware = hardware;
        this.fAnalogCalculationMethod = this.getAvailableCalculationMethod(this.fHardware);
        this.setSensor(this.createSensor(sensorTypeID));
        this.fAvailableSensors = null;
    }

    private AnalogCalculationMethod getAvailableCalculationMethod(Hardware hardware) {
        AnalogCalculation0BA3 ret = hardware == null ? null : (hardware.supports("0BA5AnalogCalculation") ? new AnalogCalculation0BA5() : (hardware.supports("0BA4AnalogCalculation") ? new AnalogCalculation0BA4() : new AnalogCalculation0BA3()));
        return ret;
    }

    protected Sensor createSensor(int sensorTypeID) {
        try {
            Sensor ret = sensorTypeID == 1 ? new Sensor0to10V(this.fAnalogCalculationMethod) : (sensorTypeID == 2 ? new Sensor0to20mA(this.fAnalogCalculationMethod) : (sensorTypeID == 3 ? new Sensor4to20mA(this.fAnalogCalculationMethod) : (sensorTypeID == 4 ? new SensorPT100(this.fAnalogCalculationMethod) : (sensorTypeID == 5 ? new SensorNoSensor(this.fAnalogCalculationMethod) : new SensorNoSensor(this.fAnalogCalculationMethod)))));
            return ret;
        }
        catch (Exception e) {
            return new Sensor0to10V(this.fAnalogCalculationMethod);
        }
    }

    public void hardwareChanged(HardwareChangedEvent hardwareChangedEvent) {
        this.fHardware = (Hardware)hardwareChangedEvent.getNewValue();
        this.fAnalogCalculationMethod = this.getAvailableCalculationMethod(this.fHardware);
        this.getSensor().setAnalogCalculationMethod(this.fAnalogCalculationMethod);
        this.fAvailableSensors = null;
    }

    public AnalogCalculationMethod getAnalogCalculationMethod() {
        if (this.fAnalogCalculationMethod == null) {
            this.fAnalogCalculationMethod = new AnalogCalculation0BA3();
        }
        return this.fAnalogCalculationMethod;
    }

    public void setAnalogCalculationMethod(AnalogCalculationMethod analogCalculationMethod) {
        this.fAnalogCalculationMethod = analogCalculationMethod;
        this.getSensor().setAnalogCalculationMethod(this.fAnalogCalculationMethod);
        this.fAvailableSensors = null;
    }

    public static class Sensor4to20mA
    extends SensorAdjustableMeasurementRange {
        public Sensor4to20mA() {
        }

        public Sensor4to20mA(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.fMinInternalValue = 200;
            this.fMaxInternalValue = 1000;
        }

        public String getName() {
            return "4-20mA";
        }
    }

    public static class SensorPT100Invers
    extends SensorPT100 {
        public SensorPT100Invers() {
            this.fMinFarenheit = 392;
            this.fMaxFarenheit = -58;
            this.fMinCelsius = 200;
            this.fMaxCelsius = -50;
        }

        public SensorPT100Invers(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.initMeasurementValues();
        }

        private void initMeasurementValues() {
            this.setGainOffset(-250, 2000);
            this.fMinFarenheit = 392;
            this.fMaxFarenheit = -58;
            this.fMinCelsius = 200;
            this.fMaxCelsius = -50;
        }

        public String getName() {
            return "pt100invers";
        }
    }

    public static class SensorPT100
    extends SensorAdjustableMeasurementRange {
        static final long serialVersionUID = -1614715467793968691L;
        private int serializedDataVersion = 2;
        protected int fMinFarenheit = -58;
        protected int fMaxFarenheit = 392;
        protected int fMinCelsius = -50;
        protected int fMaxCelsius = 200;
        public static final String FARENHEIT = "farenheit";
        public static final String CELSIUS = "celsius";
        private boolean fHighResolution;
        private String fUnit;

        public SensorPT100() {
            this.fMinInternalValue = 0;
            this.fMaxInternalValue = 1000;
        }

        public SensorPT100(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.fMinInternalValue = 0;
            this.fMaxInternalValue = 1000;
            this.fHighResolution = true;
            this.setUnit(CELSIUS);
        }

        public void setUnit(String unit) {
            int amplification;
            int n = amplification = this.isHighResolution() ? 10 : 1;
            if (unit.equals(CELSIUS)) {
                this.fUnit = CELSIUS;
                this.setMinMaxAmplifiedValue(this.fMinCelsius * amplification, this.fMaxCelsius * amplification);
            } else if (unit.equals(FARENHEIT)) {
                this.fUnit = FARENHEIT;
                this.setMinMaxAmplifiedValue(this.fMinFarenheit * amplification, this.fMaxFarenheit * amplification);
            } else {
                throw new IllegalArgumentException("Unit of SensorPT100 must be either PT100.FARENHEUT oder PT100.CELSIUS");
            }
        }

        public void read(StorableInput dr) throws IOException {
            boolean highResolution;
            super.read(dr);
            String unit = dr.readString();
            this.fHighResolution = highResolution = dr.readBoolean();
            this.setUnit(unit);
        }

        public void write(StorableOutput dw) {
            super.write(dw);
            dw.writeString(this.fUnit);
            dw.writeBoolean(this.fHighResolution);
        }

        public void loadPropertiesFrom(Sensor sensor) {
            this.fAnalogCalculationMethod = sensor.getAnalogCalculationMethod();
            if (sensor instanceof SensorPT100) {
                this.setHighResolution(((SensorPT100)sensor).isHighResolution());
                this.setUnit(((SensorPT100)sensor).getUnit());
            }
        }

        public boolean equalTo(Sensor sensor) {
            if (sensor.getClass() != this.getClass()) {
                return false;
            }
            SensorPT100 sensorPT100 = (SensorPT100)sensor;
            return sensorPT100.getUnit().equals(this.getUnit()) && sensorPT100.isHighResolution() == this.isHighResolution();
        }

        public String getName() {
            return "pt100";
        }

        public String getUnit() {
            return this.fUnit;
        }

        public int getMaxExternalValue() {
            return super.getMaxAmplifiedValue();
        }

        public int getMinExternalValue() {
            return super.getMinAmplifiedValue();
        }

        public boolean isHighResolution() {
            return this.fHighResolution;
        }

        public void setHighResolution(boolean highResolution) {
            int amplification;
            this.fHighResolution = highResolution;
            int n = amplification = highResolution ? 10 : 1;
            if (this.fUnit.equals(CELSIUS)) {
                this.fUnit = CELSIUS;
                this.setMinMaxAmplifiedValue(this.fMinCelsius * amplification, this.fMaxCelsius * amplification);
            } else if (this.fUnit.equals(FARENHEIT)) {
                this.fUnit = FARENHEIT;
                this.setMinMaxAmplifiedValue(this.fMinFarenheit * amplification, this.fMaxFarenheit * amplification);
            }
        }

        public void setUnit(char unit) {
            if (unit == 'F') {
                this.setUnit(FARENHEIT);
            } else if (unit == 'C') {
                this.setUnit(CELSIUS);
            }
        }
    }

    public static class Sensor0to10V
    extends SensorAdjustableMeasurementRange {
        public Sensor0to10V() {
        }

        public Sensor0to10V(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.fMinInternalValue = 0;
            this.fMaxInternalValue = 1000;
        }

        public String getName() {
            return "0-10V";
        }
    }

    public static class Sensor0to20mA
    extends SensorAdjustableMeasurementRange {
        static final long serialVersionUID = 1776260331648707922L;
        private int serializedDataVersion = 1;

        public Sensor0to20mA() {
        }

        public String getName() {
            return "0-20mA";
        }

        public Sensor0to20mA(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.fMinInternalValue = 0;
            this.fMaxInternalValue = 1000;
        }
    }

    public static abstract class SensorAdjustableMeasurementRange
    extends Sensor {
        static final long serialVersionUID = -7563051102415075464L;
        private int serializedDataVersion = 1;
        protected int fMinMeasuredValue;
        protected int fMaxMeasuredValue;

        public SensorAdjustableMeasurementRange() {
        }

        public SensorAdjustableMeasurementRange(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.fMinMeasuredValue = 0;
            this.fMaxMeasuredValue = 1000;
            this.fMinInternalValue = 0;
            this.fMaxInternalValue = 1000;
        }

        public boolean equalTo(Sensor sensor) {
            if (sensor.getClass() != this.getClass()) {
                return false;
            }
            return sensor.getMinInternalValue() == this.getMinInternalValue() && sensor.getMaxInternalValue() == this.getMaxInternalValue() && sensor.getMaxAmplifiedValue() == this.getMaxAmplifiedValue() && sensor.getMinAmplifiedValue() == this.getMinAmplifiedValue() && sensor.getGain() == this.getGain() && sensor.getOffset() == this.getOffset();
        }

        public void read(StorableInput dr) throws IOException {
            super.read(dr);
            this.fMinMeasuredValue = dr.readInt();
            this.fMaxMeasuredValue = dr.readInt();
            this.fGain = dr.readInt();
            this.fOffset = dr.readInt();
        }

        public void write(StorableOutput dw) {
            super.write(dw);
            dw.writeInt(this.fMinMeasuredValue);
            dw.writeInt(this.fMaxMeasuredValue);
            dw.writeInt(this.fGain);
            dw.writeInt(this.fOffset);
        }

        public void setGainOffset(int gain, int offset) {
            this.fGain = gain;
            this.fOffset = offset;
            this.fMinMeasuredValue = this.fAnalogCalculationMethod.calculateAmplifiedValue(this.fMinInternalValue, gain, offset);
            this.fMaxMeasuredValue = this.fAnalogCalculationMethod.calculateAmplifiedValue(this.fMaxInternalValue, gain, offset);
        }

        public int getGain() {
            return this.fAnalogCalculationMethod.calculateGain(this.getMinAmplifiedValue(), this.getMaxAmplifiedValue(), this.fMinInternalValue, this.fMaxInternalValue);
        }

        public int getMaxAmplifiedValue() {
            return this.fMaxMeasuredValue;
        }

        public int getMinAmplifiedValue() {
            return this.fMinMeasuredValue;
        }

        public int getOffset() {
            return this.fAnalogCalculationMethod.calculateOffset(this.getMinAmplifiedValue(), this.getMaxAmplifiedValue(), this.fMinInternalValue, this.fMaxInternalValue);
        }

        public boolean setMinMaxAmplifiedValue(int minMeasuredValue, int maxMeasuredValue) {
            this.fMinMeasuredValue = minMeasuredValue;
            this.fMaxMeasuredValue = maxMeasuredValue;
            int realMinValue = this.fAnalogCalculationMethod.calculateAmplifiedValue(this.fMinInternalValue, this.getGain(), this.getOffset());
            int realMaxValue = this.fAnalogCalculationMethod.calculateAmplifiedValue(this.fMaxInternalValue, this.getGain(), this.getOffset());
            boolean possible = minMeasuredValue == realMinValue && maxMeasuredValue == realMaxValue;
            this.fMinMeasuredValue = realMinValue;
            this.fMaxMeasuredValue = realMaxValue;
            return possible;
        }

        public void loadPropertiesFrom(Sensor sensor) {
            this.fAnalogCalculationMethod = sensor.getAnalogCalculationMethod();
            if (sensor instanceof SensorAdjustableMeasurementRange) {
                this.setMinMaxAmplifiedValue(sensor.getMinAmplifiedValue(), sensor.getMaxAmplifiedValue());
            } else {
                this.setGainOffset(sensor.getGain(), sensor.getOffset());
            }
        }
    }

    public static class SensorNoSensor
    extends Sensor {
        private static final long serialVersionUID = -2566768598246726434L;
        private int serializedDataVersion = 1;

        public SensorNoSensor() {
            this.fGain = 100;
            this.fOffset = 0;
        }

        public void setGainOffset(int gain, int offset) {
            this.fGain = gain;
            this.fOffset = offset;
        }

        public boolean equalTo(Sensor sensor) {
            if (sensor.getClass() != this.getClass()) {
                return false;
            }
            return sensor.getGain() == this.getGain() && sensor.getOffset() == this.getOffset();
        }

        public void read(StorableInput dr) throws IOException {
            super.read(dr);
            this.setGainOffset(dr.readInt(), dr.readInt());
        }

        public void write(StorableOutput dw) {
            super.write(dw);
            dw.writeInt(this.fGain);
            dw.writeInt(this.fOffset);
        }

        public int getOffset() {
            return this.fOffset;
        }

        public int getGain() {
            return this.fGain;
        }

        public SensorNoSensor(AnalogCalculationMethod analogCalculationMethod) {
            super(analogCalculationMethod);
            this.fMinInternalValue = 0;
            this.fMaxInternalValue = 1000;
            this.setGainOffset(100, 0);
        }

        public int getMaxAmplifiedValue() {
            return 10 * this.getGain() + this.getOffset();
        }

        public void setAnalogCalculationMethod(AnalogCalculationMethod analogCalculationMethod) {
            if (analogCalculationMethod.getClass() != this.fAnalogCalculationMethod.getClass()) {
                int min = this.fAnalogCalculationMethod.calculateAmplifiedValue(this.fMinInternalValue, this.fGain, this.fOffset);
                int max = this.fAnalogCalculationMethod.calculateAmplifiedValue(this.fMaxInternalValue, this.fGain, this.fOffset);
                this.fGain = analogCalculationMethod.calculateGain(min, max, this.fMinInternalValue, this.fMaxInternalValue);
                this.fOffset = analogCalculationMethod.calculateOffset(min, max, this.fMinInternalValue, this.fMaxInternalValue);
                this.fAnalogCalculationMethod = analogCalculationMethod;
            }
        }

        public int getMinAmplifiedValue() {
            return this.getOffset();
        }

        public String getName() {
            return "noSensor";
        }

        public void loadPropertiesFrom(Sensor sensor) {
            this.fAnalogCalculationMethod = sensor.getAnalogCalculationMethod();
            this.fGain = sensor.getGain();
            this.fOffset = sensor.getOffset();
        }
    }

    public static abstract class Sensor
    implements Storable,
    Serializable,
    Cloneable {
        static final long serialVersionUID = -1111108369473291126L;
        private int serializedDataVersion = 1;
        protected AnalogCalculationMethod fAnalogCalculationMethod;
        protected int fMaxInternalValue;
        protected int fMinInternalValue;
        protected int fGain;
        protected int fOffset;

        public Sensor() {
        }

        public Sensor(AnalogCalculationMethod analogCalculationMethod) {
            this.fAnalogCalculationMethod = analogCalculationMethod;
        }

        public abstract String getName();

        public final int getSensorTypeID() {
            if (this.getName().endsWith("noSensor")) {
                return 0;
            }
            if (this.getName().endsWith("0-10V")) {
                return 1;
            }
            if (this.getName().endsWith("0-20mA")) {
                return 2;
            }
            if (this.getName().endsWith("4-20mA")) {
                return 3;
            }
            if (this.getName().endsWith("pt100")) {
                return 4;
            }
            if (this.getName().endsWith("pt100invers")) {
                return 5;
            }
            return -1;
        }

        public String getNameKey() {
            return "comp.measurement." + this.getName();
        }

        public abstract int getMaxAmplifiedValue();

        public IntValueProperties getMaxAmplifiedValueProperties() {
            int min = this.fAnalogCalculationMethod.getMinimumValue(this.fMinInternalValue);
            int max = this.fAnalogCalculationMethod.getMaximumValue(this.fMaxInternalValue);
            return new IntValueProperties(min, max, 1, this.getMaxAmplifiedValue(), "error.dialog.invalidValue", "Invalid Value");
        }

        public IntValueProperties getMinAmplifiedValueProperties() {
            int min = this.fAnalogCalculationMethod.getMinimumValue(this.fMinInternalValue);
            int max = this.fAnalogCalculationMethod.getMaximumValue(this.fMaxInternalValue);
            return new IntValueProperties(min, max, 1, this.getMinAmplifiedValue(), "error.dialog.invalidValue", "Invalid Value");
        }

        public abstract int getMinAmplifiedValue();

        public abstract int getOffset();

        public abstract int getGain();

        public void write(StorableOutput dw) {
            dw.writeStorable(this.fAnalogCalculationMethod);
            dw.writeInt(this.fMinInternalValue);
            dw.writeInt(this.fMaxInternalValue);
        }

        public abstract boolean equalTo(Sensor var1);

        public abstract void loadPropertiesFrom(Sensor var1);

        public abstract void setGainOffset(int var1, int var2);

        public String toString() {
            return this.getName();
        }

        public void read(StorableInput dr) throws IOException {
            this.fAnalogCalculationMethod = (AnalogCalculationMethod)dr.readStorable();
            this.fMinInternalValue = dr.readInt();
            this.fMaxInternalValue = dr.readInt();
        }

        public IntValueProperties getGainProperties() {
            IntValueProperties gainProperties = this.fAnalogCalculationMethod.getGainBounds();
            gainProperties.setCurrentValue(this.getGain());
            return gainProperties;
        }

        public IntValueProperties getOffsetProperties() {
            IntValueProperties offsetProperties = this.fAnalogCalculationMethod.getOffsetBounds();
            offsetProperties.setCurrentValue(this.getOffset());
            return offsetProperties;
        }

        public AnalogCalculationMethod getAnalogCalculationMethod() {
            return this.fAnalogCalculationMethod;
        }

        public void setAnalogCalculationMethod(AnalogCalculationMethod analogCalculationMethod) {
            if (analogCalculationMethod.getClass() != this.fAnalogCalculationMethod.getClass()) {
                int orgMinGain = analogCalculationMethod.getGainBounds().getMin();
                int min = Math.min(this.fAnalogCalculationMethod.getGainBounds().getMin(), orgMinGain);
                analogCalculationMethod.setMinGain(min);
                this.fAnalogCalculationMethod = analogCalculationMethod;
                this.fGain = analogCalculationMethod.calculateGain(this.getMinAmplifiedValue(), this.getMaxAmplifiedValue(), this.fMinInternalValue, this.fMaxInternalValue);
                this.fOffset = analogCalculationMethod.calculateOffset(this.getMinAmplifiedValue(), this.getMaxAmplifiedValue(), this.fMinInternalValue, this.fMaxInternalValue);
                analogCalculationMethod.setMinGain(orgMinGain);
            }
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public int getMinExternalValue() {
            return this.getMinAmplifiedValue();
        }

        public int getMaxExternalValue() {
            return this.getMaxAmplifiedValue();
        }

        public int getMaxInternalValue() {
            return this.fMaxInternalValue;
        }

        public int getMinInternalValue() {
            return this.fMinInternalValue;
        }
    }

    public static class AnalogCalculation0BA5
    extends AnalogCalculation0BA4 {
        static final long serialVersionUID = 1L;
        private int serializedDataVersion = 1;

        public AnalogCalculation0BA5() {
            this.fMinGain = -1000;
        }

        public int calculateOffset(int minExt, int maxExt, int minInt, int maxInt) {
            int result = minExt > maxExt ? minExt : super.calculateOffset(minExt, maxExt, minInt, maxInt);
            return result;
        }

        public int getMaximumValue(int maxinternalValue) {
            if (this.fMaxGain > 0) {
                return this.calculateAmplifiedValue(maxinternalValue, this.fMaxGain, this.fMaxOffset);
            }
            return this.calculateAmplifiedValue(maxinternalValue, this.fMaxGain, this.fMaxOffset);
        }

        public int getMinimumValue(int minInternalValue) {
            return this.calculateAmplifiedValue(minInternalValue, this.fMinGain, this.fMinOffset);
        }
    }

    public static class AnalogCalculation0BA4
    extends AnalogCalculation0BA3 {
        static final long serialVersionUID = -6168610411030583533L;
        private int serializedDataVersion = 1;

        public AnalogCalculation0BA4() {
            this.fMinOffset = -10000;
            this.fMaxOffset = 10000;
        }

        public int calculateGain(int minExt, int maxExt, int minInt, int maxInt) {
            int gain = (int)Math.round((double)(maxExt - minExt) / (double)(maxInt - minInt) * 100.0);
            gain = Math.min(gain, this.fMaxGain);
            gain = Math.max(gain, this.fMinGain);
            return gain;
        }

        public IntValueProperties getGainBounds() {
            return new AnalogValueProperties(this.fMinGain, this.fMaxGain, 1, this.fMinGain, 2, true, "error.dialog.invalidValue", "Invalid Value");
        }

        public int calculateOffset(int minExt, int maxExt, int minInt, int maxInt) {
            int offset = Math.round((maxExt * minInt - minExt * maxInt) / (minInt - maxInt));
            offset = Math.min(offset, this.fMaxOffset);
            offset = Math.max(offset, this.fMinOffset);
            return offset;
        }

        public int getMaximumValue(int maxinternalValue) {
            return this.calculateAmplifiedValue(maxinternalValue, this.fMaxGain, this.fMaxOffset);
        }

        public int getMinimumValue(int minInternalValue) {
            return this.calculateAmplifiedValue(minInternalValue, this.fMinGain, this.fMinOffset);
        }

        public int calculateAmplifiedValue(int source, int gain, int offset) {
            int amplifiedValue = (int)Math.round((double)source * ((double)gain / 100.0) + (double)offset);
            amplifiedValue = Math.max(amplifiedValue, -32767);
            amplifiedValue = Math.min(amplifiedValue, Short.MAX_VALUE);
            return amplifiedValue;
        }

        public int calculateInternalValue(int amplifiedValue, int gain, int offset) {
            return (int)Math.round((double)(amplifiedValue - offset) / ((double)gain / 100.0));
        }
    }

    public static class AnalogCalculation0BA3
    extends AnalogCalculationMethod {
        static final long serialVersionUID = -3707307487353893609L;
        private int serializedDataVersion = 1;
        protected int fMaxGain = 1000;
        protected int fMaxOffset = 999;
        protected int fMinGain = 0;
        protected int fMinOffset = -999;

        public int calculateGain(int minExt, int maxExt, int minInt, int maxInt) {
            int gain = (int)Math.round((double)(maxExt - minExt) / (double)(maxInt - minInt) * 100.0);
            gain = Math.min(gain, this.fMaxGain);
            gain = Math.max(gain, this.fMinGain);
            return gain;
        }

        public int calculateOffset(int minExt, int maxExt, int minInt, int maxInt) {
            if (minExt == maxExt) {
                return minExt;
            }
            int offset = Math.round((maxExt * minInt - minExt * maxInt) / (minExt - maxExt));
            offset = Math.min(offset, this.fMaxOffset);
            offset = Math.max(offset, this.fMinOffset);
            return offset;
        }

        public int calculateAmplifiedValue(int source, int gain, int offset) {
            return (int)Math.round((double)(source + offset) * ((double)gain / 100.0));
        }

        public int calculateInternalValue(int amplifiedValue, int gain, int offset) {
            return (int)Math.round((double)amplifiedValue / ((double)gain / 100.0) - (double)offset);
        }

        public IntValueProperties getOffsetBounds() {
            return new IntValueProperties(this.fMinOffset, this.fMaxOffset, 1, this.fMinOffset, "error.dialog.invalidValue", "Invalid Value");
        }

        public int getMaximumValue(int maxinternalValue) {
            return this.calculateAmplifiedValue(maxinternalValue, this.fMaxGain, this.fMaxOffset);
        }

        public int getMinimumValue(int minInternalValue) {
            return this.calculateAmplifiedValue(minInternalValue, this.fMaxGain, this.fMinOffset);
        }

        public IntValueProperties getGainBounds() {
            return new IntValueProperties(this.fMinGain, this.fMaxGain, 1, this.fMinGain, "error.dialog.invalidValue", "Invalid Value");
        }

        public void setMinGain(int minGainValue) {
            this.fMinGain = minGainValue;
        }
    }

    public static abstract class AnalogCalculationMethod
    implements Storable,
    Serializable {
        static final long serialVersionUID = -5494776118932639385L;
        private int serializedDataVersion = 1;

        public abstract int calculateInternalValue(int var1, int var2, int var3);

        public abstract int calculateAmplifiedValue(int var1, int var2, int var3);

        public abstract int calculateGain(int var1, int var2, int var3, int var4);

        public abstract int calculateOffset(int var1, int var2, int var3, int var4);

        public abstract IntValueProperties getOffsetBounds();

        public abstract int getMinimumValue(int var1);

        public abstract int getMaximumValue(int var1);

        public abstract IntValueProperties getGainBounds();

        public abstract void setMinGain(int var1);

        public void read(StorableInput dr) throws IOException {
        }

        public void write(StorableOutput dw) {
        }
    }
}

